<?php
header('Content-Type: application/json');

// Database config
include "db.php";

$email = $_GET['email'] ?? '';

if (empty($email)) {
    echo json_encode(["success" => false, "error" => "Email is required"]);
    exit;
}

$stmt = $conn->prepare("SELECT api_key, request_limit, expiration_time, status FROM users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["success" => false, "error" => "User not found"]);
    exit;
}

$user = $result->fetch_assoc();

$response = [
    "success" => true,
    "email" => $email,
    "api_key" => $user['api_key'],
    "available_credit" => (float)$user['request_limit'],
    "expiry_unix" => (int)$user['expiration_time'],
    "expiry_date" => date("Y-m-d H:i:s", $user['expiration_time']),
    "status" => $user['status']  // New line
];

echo json_encode($response, JSON_PRETTY_PRINT);
$conn->close();