<?php

// আপনার API থেকে আসা ডেটা থেকে মেসেজটি নেওয়া হচ্ছে
$message = $_GET['message'] ?? '';

// একটি ফাংশন যা মেসেজে বাংলা বা GSM 7-bit এর বাইরের কোনো অক্ষর আছে কিনা তা পরীক্ষা করবে।
// এই ফাংশনটি মেসেজটি কোন এনকোডিং ব্যবহার করবে তা নির্ধারণে সাহায্য করবে।
function requiresUnicode($text) {
    // এটি চেক করে যে টেক্সটে GSM 7-bit বাদে অন্য কোনো অক্ষর আছে কিনা।
    // বাংলা বা অন্যান্য বিশেষ অক্ষর এই সীমার বাইরে থাকে।
    return preg_match('/[^\x00-\x7F]/', $text);
}

// এখন মেসেজের এনকোডিং চেক করা যাক
if (requiresUnicode($message)) {
    // যদি মেসেজে বাংলা বা অন্য কোনো বিশেষ অক্ষর থাকে, তবে UTF-8 এনকোডিং ধরা হবে।
    // এই এনকোডিং-এ প্রতিটি SMS অংশে ৭০টি অক্ষর থাকে।
    $character_limit = 70;
    $encoding_type = 'UTF-8';
} else {
    // যদি শুধুমাত্র ইংরেজি এবং GSM এর অন্তর্ভুক্ত বিশেষ অক্ষর থাকে,
    // তবে GSM_7BIT_EX এনকোডিং ব্যবহার করা হবে।
    // এই এনকোডিং-এ প্রতিটি SMS অংশে ১৬০টি অক্ষর থাকে।
    $character_limit = 160;
    $encoding_type = 'GSM_7BIT_EX';
}

// mb_strlen() ফাংশন ব্যবহার করে সঠিক অক্ষর সংখ্যা গণনা করা হচ্ছে,
// কারণ এটি সব ধরনের এনকোডিংয়ের জন্য সঠিকভাবে কাজ করে।
$character_count = mb_strlen($message, 'UTF-8');

// SMS অংশের সংখ্যা গণনা
$segments = ceil($character_count / $character_limit);

// আপনার ফলাফল:
echo "Encoding: " . $encoding_type . "\n";
echo "Character Count: " . $character_count . "\n";
echo "SMS Parts: " . $segments . "\n";

?>