<?php
// sms_get_api.php
// CORS & Content-Type
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
date_default_timezone_set('Asia/Dhaka');
include "db.php";
$conn->query("SET time_zone = '+06:00'");

// 1. Collect input from GET
$api_key = $_GET['api'] ?? '';
$numbers_raw = $_GET['number'] ?? '';
$message = $_GET['message'] ?? '';

$errors = [];
if (empty($api_key)) $errors[] = "API key is missing.";
if (empty($numbers_raw)) $errors[] = "Mobile numbers are missing.";
if (empty($message)) $errors[] = "Message text is missing.";

if (!empty($errors)) {
    echo json_encode(["success" => false, "message" => implode(" ", $errors)]);
    exit;
}

// 2. Validate user
$stmt = $conn->prepare("SELECT * FROM users WHERE api_key = ?");
$stmt->bind_param("s", $api_key);
$stmt->execute();
$user_result = $stmt->get_result();

if ($user_result->num_rows === 0) {
    echo json_encode(["success" => false, "message" => "Invalid API key."]);
    exit;
}

$user = $user_result->fetch_assoc();
$email = $user['email'];

// Block & expiry check
if ($user['status'] !== 'active') {
    echo json_encode(["success" => false, "message" => "Account is blocked."]);
    exit;
}

if (time() > $user['expiration_time']) {
    echo json_encode(["success" => false, "message" => "API access has expired."]);
    exit;
}

// 3. SMS calculation
function requiresUnicode($text) {
    return preg_match('/[^\x00-\x7F]/', $text);
}

if (requiresUnicode($message)) {
    $character_limit = 70;
    $encoding_type = 'UTF-8';
} else {
    $character_limit = 160;
    $encoding_type = 'GSM_7BIT_EX';
}

$character_count = mb_strlen($message, 'UTF-8');
$segments = ceil($character_count / $character_limit);
$numbers = array_filter(array_map('trim', explode(',', $numbers_raw)));
$total_numbers = count($numbers);
$cost_per_segment = 0.40;
$total_cost = $segments * $total_numbers * $cost_per_segment;

if ($user['request_limit'] < $total_cost) {
    echo json_encode([
        "success" => false,
        "message" => "Insufficient balance.",
        "required" => $total_cost,
        "available_balance" => $user['request_limit']
    ]);
    exit;
}

// 4. Send SMS via BulkSMSBD
$sent = 0;
$failures = [];

foreach ($numbers as $number) {
    $number = preg_replace('/[^0-9]/', '', $number);
    if (strlen($number) < 10) continue;

    $api_url = "http://bulksmsbd.net/api/smsapi?api_key=PGH6awSDlG2SvKfgcU9A&type=text&number=" . urlencode($number) . "&senderid=8809617613571&message=" . urlencode($message);

    $ch = curl_init($api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code == 200 && $response) {
        $cost = $segments * $cost_per_segment;
        $stmt2 = $conn->prepare("INSERT INTO sms_logs (email, number, message, segments, cost, api_key, sent_at) VALUES (?, ?, ?, ?, ?, ?, NOW())");
        $stmt2->bind_param("sssdds", $email, $number, $message, $segments, $cost, $api_key);
        $stmt2->execute();
        $sent++;
    } else {
        $failures[] = $number;
    }
}

// 5. Update balance
$new_balance = $user['request_limit'] - $total_cost;
$conn->query("UPDATE users SET request_limit = $new_balance WHERE email = '$email'");

// 6. Return response
echo json_encode([
    "success" => true,
    "message" => "SMS process completed.",
    "sent" => $sent,
    "failed" => $failures,
    "total_numbers" => $total_numbers,
    "segments" => $segments,
    "cost_per_segment" => $cost_per_segment,
    "total_cost" => $total_cost,
    "new_balance" => number_format($new_balance, 2),
    "email" => $email,
    "encode" => $encoding_type
], JSON_PRETTY_PRINT);
?>
